%% Script to create Figure 1.X Aliasing
% Inspired by Parthier, Messtechnik, Fig. 2.5
clc, close all, clear

%%
colors = [
0 114 189
217 83 25
237 177 32
126 47 142
]./255;

%%
% Original time series with a period of 2 or frequency 0.5 
t = 0 : 0.01 : 15; t = t';
x1 = sin(2*pi*t/2);

%%
% Calculating Alias Frequency:
% fa = |f - fs * NINT(f/fs)|
% where
% f = original signal frequency
% fs = sampling frequency
% NINT = nearest integer function using rounding half up rule
% in our example
fa = abs(0.5 - 0.6250 * round(0.5/0.6250))

%%
% Sample points. The sampling frequency is 1/1.6 = 0.6250. The Nyquist
% Frequency therefore is half of that, 1/3.2 = 0.3125.
ts = 0 : 1.6 : 15; ts = ts';
x2 = interp1(t,x1,ts,'linear','extrap');

%%
% Alias frequency of the signal is 0.125 or period of 8. The original
% signal has a frequency of 0.5 which is above the Nyquist frequency of
% 0.3125 and therefore should not be used. If your analog signal has that
% frequency of 0.5 you need to apply an anti alias low pass filter to
% remove that high frequency to avoid aliasing.
x3 = sin(2*pi*t*fa + 2*pi*3.5);

%%
% Graphical display.
f1 = figure('Position',[100 1000 800 300],...
    'Color','w');
axes('Position',[0.1 0.15 0.8 0.7],...
  'YLim',[-1.2 1.2])
hold on
line(t,x1,...
  'Color',colors(1,:),...
  'LineWidth',1)
s1 = stem(ts,x2,...
  'Color',colors(2,:),...
  'LineWidth',1,...
  'Marker','o',...
  'MarkerSize',12);
line(t,x3,...
  'Color',colors(3,:),...
  'LineWidth',1)
xlabel('Age (kyr)')
ylabel('Proxy (unit)')
s1.BaseLine.LineStyle = ':';
s1.BaseLine.LineWidth = 1;

print(f1,'-dpng','-r300','figure_4_aliasing.png')






